import RPi.GPIO as GPIO  
import time  
import datetime


# blinking function  
def blink_slow(pin):  
        GPIO.output(pin,GPIO.HIGH)  
        time.sleep(1)  
        GPIO.output(pin,GPIO.LOW)  
        time.sleep(1)  
        return  
def blink_fast(pin):  
        GPIO.output(pin,GPIO.HIGH)  
        time.sleep(60.0 / 1000.0)  
        GPIO.output(pin,GPIO.LOW)  
        time.sleep(60.0 / 1000.0)  
        return  


#
# MAIN
#

# to use Raspberry Pi board pin numbers  
GPIO.setmode(GPIO.BOARD)  
# set up GPIO output channel  
GPIO.setup(18, GPIO.OUT)  

now = datetime.datetime.now()

# blink hour
for i in range(0,now.hour):  
        blink_slow(18)
# blink min
for i in range(0,now.minute):  
        blink_fast(18)

  
GPIO.cleanup()
